import React from 'react';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import Breadcrumbs from 'components/Breadcrumbs/Breadcrumbs';
import {IAviaRouteBreadcrumbs} from 'projects/avia/pages/AviaLanding/components/Breadcrumbs/IAviaRouteBreadcrumbs';

const AviaRouteBreadcrumbsDesktop: React.FC<IAviaRouteBreadcrumbs> = ({
    block: {data},
    ...props
}) => {
    return (
        <Breadcrumbs {...prepareQaAttributes(props)}>
            {data.items.map(item => (
                <Breadcrumbs.Item
                    key={item.title}
                    active={!item.link}
                    url={item.link}
                >
                    {item.title}
                </Breadcrumbs.Item>
            ))}
        </Breadcrumbs>
    );
};

export default AviaRouteBreadcrumbsDesktop;
