import React from 'react';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import {IAviaRouteBreadcrumbs} from 'projects/avia/pages/AviaLanding/components/Breadcrumbs/IAviaRouteBreadcrumbs';
import LinkBreadcrumbs from 'components/LinkBreadcrumbs/LinkBreadcrumbs';

import cx from './BreadcrumbsMobile.scss';

const AviaRouteBreadcrumbsMobile: React.FC<IAviaRouteBreadcrumbs> = ({
    block: {data},
    ...props
}) => {
    return (
        <LinkBreadcrumbs
            scrollableClassName={cx('root')}
            {...prepareQaAttributes(props)}
        >
            {data.items.map(item => (
                <LinkBreadcrumbs.Item
                    key={item.title}
                    className={cx('item')}
                    url={item.link}
                >
                    {item.title}
                </LinkBreadcrumbs.Item>
            ))}
        </LinkBreadcrumbs>
    );
};

export default AviaRouteBreadcrumbsMobile;
