import {createSelector} from 'reselect';

import {getAviaContext} from 'selectors/avia/aviaSelectors';

import * as i18n from 'i18n/avia-FlightsTo';

const titleSelector = createSelector(
    [getAviaContext],
    (context): string | undefined => {
        const from = context.fromName;
        const to = context.toName;

        if (!from || !to) {
            return undefined;
        }

        return i18n.dynamicBlockTitle({from, to});
    },
);

export default titleSelector;
