import React from 'react';

import * as i18nBlock from 'i18n/page-error-boundary';

import NotFoundPage from 'components/NotFound/NotFoundPage/NotFoundPage';
import LayoutError500 from 'components/Layouts/LayoutError500/LayoutError500';
import LayoutDefault from 'components/Layouts/LayoutDefault/LayoutDefault';

interface IErrorProps {
    isNotFound: boolean;
}

const Error: React.FC<IErrorProps> = ({isNotFound}) => {
    if (isNotFound) {
        return <NotFoundPage />;
    }

    return (
        <LayoutDefault>
            <LayoutError500
                title={i18nBlock.title()}
                subtitle={i18nBlock.subtitle()}
                action={{
                    type: 'button',
                    title: i18nBlock.actionDashTitle(),
                    handler: () => window.document.location.reload(),
                }}
            />
        </LayoutDefault>
    );
};

export default Error;
