import React from 'react';
import {useParams} from 'react-router-dom';
import {useSelector} from 'react-redux';

import flightsToDataSelector from 'selectors/avia/landing/flightsToDataSelector';

import {aviaURLs} from 'projects/avia/lib/urls';

import SocialSharingMeta from 'components/SocialSharingMeta/SocialSharingMeta';
import DocumentMeta, {
    IAlternateLink,
} from 'components/DocumentMeta/DocumentMeta';

interface IDirectionSlug {
    toSlug: string;
}

function getAlternates({toSlug}: IDirectionSlug): IAlternateLink[] {
    return [
        {
            href: aviaURLs.getFlightsToPageUrl(toSlug, undefined, {
                withOrigin: true,
            }),
            hreflang: 'ru',
        },
    ];
}

const FlightsToMetaHelmet: React.FC = () => {
    const {seoInfo} = useSelector(flightsToDataSelector);
    const directionSlugs = useParams<IDirectionSlug>();
    const {toSlug} = directionSlugs;

    const absoluteFlightsToUrl = aviaURLs.getFlightsToPageUrl(
        toSlug,
        undefined,
        {withOrigin: true},
    );

    if (!seoInfo) {
        return null;
    }

    const {
        title,
        description,
        openGraph: {
            title: ogTitle,
            description: ogDescription,
            image: ogImage,
            imageSize: ogImageSize,
        },
    } = seoInfo;

    return (
        <>
            <DocumentMeta
                title={title}
                description={description}
                canonicalUrl={absoluteFlightsToUrl}
                alternates={getAlternates(directionSlugs)}
            />
            <SocialSharingMeta
                url={absoluteFlightsToUrl}
                title={ogTitle}
                description={ogDescription}
                image={ogImage}
                imageHeight={ogImageSize?.height ?? ''}
                imageWidth={ogImageSize?.width ?? ''}
                twitterCardType="summary_large_image"
            />
        </>
    );
};

export default FlightsToMetaHelmet;
