import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {ILandingSectionTextBlock} from 'types/avia/landing/IAviaLanding';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import SectionTextBlock from 'components/SectionTextBlock/SectionTextBlock';

interface ILandingSectionBlock extends IWithClassName {
    block: ILandingSectionTextBlock;
}

export default React.forwardRef<HTMLDivElement, ILandingSectionBlock>(
    function LandingSectionTextBlock(props, ref) {
        const deviceType = useDeviceType();
        const {className, block} = props;

        return (
            <div className={className} ref={ref}>
                <SectionTextBlock
                    deviceType={deviceType}
                    block={{
                        type: block.type,
                        data: {
                            title: block.data.title,
                            text: block.data.text,
                        },
                        children: block.children,
                    }}
                />
            </div>
        );
    },
);
