import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';

import * as i18nBlock from 'i18n/avia-route';

import Heading from 'components/Heading/Heading';
import Box from 'components/Box/Box';
import LinkButton from 'components/LinkButton/LinkButton';

interface INavigation extends IWithClassName, IWithDeviceType {
    items: string[];
    onClick: (index: number) => () => void;
}

const Navigation: React.FC<INavigation> = ({
    className,
    deviceType,
    items,
    onClick,
}) => {
    if (items.length === 0) {
        return null;
    }

    return (
        <div className={className}>
            <Box below={deviceType.isDesktop ? 5 : 4}>
                <Heading level={2}>{i18nBlock.navigationTitle()}</Heading>
            </Box>
            <Box between={2} textSize="m">
                {items.map((item, index) => (
                    <div key={index}>
                        <LinkButton onClick={onClick(index)}>{item}</LinkButton>
                    </div>
                ))}
            </Box>
        </div>
    );
};

export default Navigation;
