import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {IRouteSearchFormBlock} from 'types/avia/landing/route/IAviaRoute';
import {ESearchFormFieldName} from 'components/SearchForm/types';
import {EAviaGoal} from 'utilities/metrika/types/goals/avia';
import {IFlightsToSearchFormBlock} from 'types/avia/landing/flightsTo/IAviaFlightsTo';

import {deviceMods} from 'utilities/stylesUtils';
import {useReachGoal} from 'utilities/metrika/useReachGoal';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import CommonSearchForm from 'projects/avia/components/SearchForm/SearchForm';
import Heading from 'components/Heading/Heading';

import cx from './SearchForm.scss';

interface ISearchForm extends IWithClassName {
    block: IRouteSearchFormBlock | IFlightsToSearchFormBlock;
}

const SearchForm: React.FC<ISearchForm> = ({className, block: {data}}) => {
    const handleSubmitForm = useReachGoal(EAviaGoal.ROUTES_SEARCH);
    const deviceType = useDeviceType();

    return (
        <div className={cx(className, 'aviaSearchBlock')}>
            {deviceType.isDesktop ? (
                <img
                    className={cx('aviaRouteImage')}
                    src={data.imageUrl}
                    alt={data.title}
                />
            ) : null}
            <div
                className={cx(
                    'aviaSearchCard',
                    deviceMods('aviaSearchCard', deviceType),
                )}
            >
                <Heading
                    level={deviceType.isDesktop ? 1 : 2}
                    className={cx(
                        'mainTitle',
                        deviceMods('mainTitle', deviceType),
                    )}
                >
                    {data.title}
                </Heading>
                <CommonSearchForm
                    useFiltersFromUrl
                    autoFocusFieldName={
                        data.searchFormParams.isCalendarOpen
                            ? ESearchFormFieldName.START_DATE
                            : undefined
                    }
                    onSubmit={handleSubmitForm}
                    hideDefaultGoal
                />
            </div>
        </div>
    );
};

export default SearchForm;
