import {AVIA_DEFAULT_PARAMS} from 'constants/avia';

import {IAviaCompanyPriceBlock} from 'types/avia/landing/IAviaLanding';

import {EAviaSearchTransferFilter} from 'reducers/avia/search/results/filters/reducer';

import * as Flags from 'utilities/flags/flags';
import {aviaURLs} from 'projects/avia/lib/urls';
import {disable, enable} from 'utilities/flags/flags';
import getFiltersForUrl from 'projects/avia/utilities/getFiltersForUrl';

import {ILinksListItem} from 'components/LinksList/components/LinksListItem';

export function prepareAviaCompaniesItems(
    items: IAviaCompanyPriceBlock[],
    fromId: string,
    toId: string,
): ILinksListItem[] {
    return items.map((item: IAviaCompanyPriceBlock) => {
        const url = aviaURLs.getSearchResultsUrl(
            {
                ...AVIA_DEFAULT_PARAMS,
                fromId,
                toId,
                when: item.when,
                returnDate: item.returnDate,
            },
            getFiltersForUrl({
                company: {
                    companiesIds: [parseInt(item.id, 10)],
                    combinationsAreEnabled: false,
                },
                transfer: {
                    value: item.withTransfers
                        ? disable(
                              Flags.createFlags<EAviaSearchTransferFilter>(),
                              EAviaSearchTransferFilter.NO_TRANSFERS,
                          )
                        : enable(
                              Flags.createFlags<EAviaSearchTransferFilter>(),
                              EAviaSearchTransferFilter.NO_TRANSFERS,
                          ),
                    range: null,
                },
            }),
        );

        return {
            text: item.name,
            price: item.price,
            link: {
                url,
                target: '_blank',
            },
        };
    });
}
