import {ICityDirectionItem} from 'types/avia/landing/IAviaLanding';

import {aviaURLs} from 'projects/avia/lib/urls';

import {ILinksListItem} from 'components/LinksList/components/LinksListItem';

export function prepareCityDirectionsItems(
    items: ICityDirectionItem[],
    toSlug: string | undefined,
): ILinksListItem[] {
    if (!toSlug) {
        return [];
    }

    return items.map(item => {
        const url = aviaURLs.getRoutePageUrl(item.fromSlug, toSlug);

        return {
            text: item.name,
            link: {
                url,
                target: '_blank',
            },
            price: item.price,
        };
    });
}
