import {ICityPriceBlock} from 'types/avia/landing/IAviaLanding';

import {aviaURLs} from 'projects/avia/lib/urls';

import {ILinksListItem} from 'components/LinksList/components/LinksListItem';

export function prepareClosesCitiesItems(
    items: ICityPriceBlock[],
): ILinksListItem[] {
    return items.map((item: ICityPriceBlock) => {
        const url = aviaURLs.getFlightsToPageUrl(item.toSlug);

        return {
            text: item.name,
            price: item.price,
            link: {
                url,
                target: '_blank',
            },
        };
    });
}
