import {ILandingRoutePrice} from 'types/avia/landing/IAviaLanding';

import {aviaURLs} from 'projects/avia/lib/urls';

import {ILinksListItem} from 'components/LinksList/components/LinksListItem';

export function prepareReturnTicketItems(
    items: ILandingRoutePrice[],
): ILinksListItem[] {
    return items.map((item: ILandingRoutePrice) => {
        const url = aviaURLs.getRoutePageUrl(item.fromSlug, item.toSlug);

        return {
            text: item.name,
            price: item.price,
            link: {
                url,
                target: '_blank',
            },
        };
    });
}
