import {USER_SETTLEMENT} from 'projects/avia/constants/constants';

import {ServerDataFetcherBag} from 'server/redux/types';

import {IAviaRequestRouteDataAction} from 'reducers/avia/route/actions';

import {getUserGeoLocation} from 'selectors/common/userInfoSelector';

import {aviaURLs} from 'projects/avia/lib/urls';
import requestGeoLookup from 'projects/avia/utilities/api/requestGeoLookup';
import {resolveContainerValue} from 'server/utilities/container/resolve';

import {IAviaSettlementSlugResponse} from 'server/api/AviaSettlementSlugApi/AviaSettlementSlugTypes';

function prepareSlugs(
    fromSlug: string,
    toSlug: string,
    geoId: number,
    geoIdToSlug: IAviaSettlementSlugResponse,
) {
    const fromSlugPrepared =
        fromSlug === USER_SETTLEMENT ? geoIdToSlug.data[geoId] : fromSlug;
    const toSlugPrepared =
        toSlug === USER_SETTLEMENT ? geoIdToSlug.data[geoId] : toSlug;

    return {
        fromSlugPrepared,
        toSlugPrepared,
    };
}

function redirectToAviaRoot(serverFetcherData: ServerDataFetcherBag) {
    const {req, res} = serverFetcherData;

    res.redirect(302, aviaURLs.getAviaRoot(req.query));
}

export async function redirect(
    serverFetcherData: ServerDataFetcherBag,
    slugs: IAviaRequestRouteDataAction,
) {
    const {req, res, getState} = serverFetcherData;

    const {fromSlug, toSlug} = slugs;

    const {geoId: geoIdCommon} = await getUserGeoLocation(getState());

    if (!geoIdCommon) {
        return redirectToAviaRoot(serverFetcherData);
    }

    const geoLookupResponse = await requestGeoLookup({
        geoId: geoIdCommon,
        req,
    });

    if (!geoLookupResponse) {
        return redirectToAviaRoot(serverFetcherData);
    }

    const {
        searchCity: {geoId},
    } = geoLookupResponse;

    if (!geoId) {
        return redirectToAviaRoot(serverFetcherData);
    }

    const aviaRouteService = resolveContainerValue(
        req.container,
        'aviaSettlementSlugService',
    );

    const geoIdToSlug = await aviaRouteService.getSettlementSlugByGeoId({
        geoId,
    });

    const {fromSlugPrepared, toSlugPrepared} = prepareSlugs(
        fromSlug,
        toSlug,
        geoId,
        geoIdToSlug,
    );

    const to =
        fromSlugPrepared === toSlugPrepared
            ? aviaURLs.getAviaRoot(req.query)
            : aviaURLs.getRoutePageUrl(
                  fromSlugPrepared,
                  toSlugPrepared,
                  req.query,
              );

    res.redirect(302, to);
}
