import React, {FunctionComponent, RefObject, useState} from 'react';
import {RouteComponentProps} from 'react-router-dom';

import {loadable} from 'utilities/pageLoadable';
import {IBrowserHistoryState} from 'utilities/browserHistory/browserHistory';

import Modal, {EModalAnimationType} from 'components/Modal/Modal';

import {IAviaOrderOwnProps} from 'projects/avia/pages/AviaOrder/AviaOrder';
import {AviaOrderContext} from 'projects/avia/pages/AviaOrder/context/AviaOrderContext';

export const Order = loadable<IAviaOrderOwnProps>(
    () => import('projects/avia/pages/AviaOrder/AviaOrder'),
);

interface IModalOrderProps {
    variantKey?: string;
}

const ModalOrder: FunctionComponent<IModalOrderProps> = ({variantKey}) => {
    const [modalRootRef, setModalRootRef] =
        useState<RefObject<HTMLElement> | null>(null);

    return (
        <AviaOrderContext.Provider value={{modalRootRef}}>
            <Modal
                fullScreen
                isVisible
                animation={EModalAnimationType.NONE}
                hasCloseButton={false}
                getRootRef={setModalRootRef}
            >
                <Order isModalView variantKey={variantKey} />
            </Modal>
        </AviaOrderContext.Provider>
    );
};

const ModalOrderMemoized = React.memo(ModalOrder);

export const OrderAsPage = ({
    location,
}: RouteComponentProps<any, any, IBrowserHistoryState>) => (
    <AviaOrderContext.Provider value={{modalRootRef: null}}>
        <Order isModalView={false} variantKey={location?.state?.variantKey} />
    </AviaOrderContext.Provider>
);

export const ModalOrderRouted = ({
    location,
}: RouteComponentProps<any, any, IBrowserHistoryState>) => (
    <ModalOrderMemoized variantKey={location?.state?.variantKey} />
);
