import * as i18nBlock from 'i18n/avia-metaOrder';

interface ITextFunctions {
    ogDescription:
        | typeof i18nBlock.ogDashDescriptionDashRoundDashTrip
        | typeof i18nBlock.ogDashDescriptionDashOneDashWay
        | typeof i18nBlock.staticDashOgDashDescriptionDashRoundDashTrip
        | typeof i18nBlock.staticDashOgDashDescriptionDashOneDashWay;
    ogTitle:
        | typeof i18nBlock.ogDashTitleDashRoundDashTrip
        | typeof i18nBlock.ogDashTitleDashOneDashWay
        | typeof i18nBlock.staticDashOgDashTitleDashRoundDashTrip
        | typeof i18nBlock.staticDashOgDashTitleDashOneDashWay;
    title:
        | typeof i18nBlock.titleDashRoundDashTrip
        | typeof i18nBlock.titleDashOneDashWay
        | typeof i18nBlock.staticDashTitleDashRoundDashTrip
        | typeof i18nBlock.staticDashTitleDashOneDashWay;
}

export default function getTextFunctions(
    hasOffers: boolean,
    hasReturnDate: boolean,
): ITextFunctions {
    if (hasOffers) {
        return hasReturnDate
            ? {
                  ogDescription: i18nBlock.ogDashDescriptionDashRoundDashTrip,
                  ogTitle: i18nBlock.ogDashTitleDashRoundDashTrip,
                  title: i18nBlock.titleDashRoundDashTrip,
              }
            : {
                  ogDescription: i18nBlock.ogDashDescriptionDashOneDashWay,
                  ogTitle: i18nBlock.ogDashTitleDashOneDashWay,
                  title: i18nBlock.titleDashOneDashWay,
              };
    }

    return hasReturnDate
        ? {
              ogDescription:
                  i18nBlock.staticDashOgDashDescriptionDashRoundDashTrip,
              ogTitle: i18nBlock.staticDashOgDashTitleDashRoundDashTrip,
              title: i18nBlock.staticDashTitleDashRoundDashTrip,
          }
        : {
              ogDescription:
                  i18nBlock.staticDashOgDashDescriptionDashOneDashWay,
              ogTitle: i18nBlock.staticDashOgDashTitleDashOneDashWay,
              title: i18nBlock.staticDashTitleDashOneDashWay,
          };
}
