import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {IAviaOrderOffers} from 'selectors/avia/order/aviaOrderSelector';
import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/avia-AviaOrder-PriceList';

import AviaOrderOffer from 'projects/avia/pages/AviaOrder/components/AviaOrderOffer/AviaOrderOffer';

import {usePlatform} from 'contexts/PlatformContext';

import cx from './BestOffer.scss';

interface IBestOfferProps extends IWithClassName {
    offers: IAviaOrderOffers;
    qid: string;
    selectedVariant: IResultAviaVariant | null;
}

const BestOffer: React.FC<IBestOfferProps> = props => {
    const {qid, className, selectedVariant} = props;
    const {isIos} = usePlatform();

    if (!selectedVariant) {
        return null;
    }

    return (
        <div
            className={cx(className, 'root', {
                root_IOS: isIos,
            })}
            {...prepareQaAttributes('bestOffer')}
        >
            <div className={cx('wrapper')}>
                <div className={cx('title')}>
                    {selectedVariant.price.fromCompany &&
                    !selectedVariant.price.boy
                        ? i18nBlock.titleDashBestDashAvia()
                        : i18nBlock.titleDashBest()}
                </div>

                <AviaOrderOffer offer={selectedVariant} isBestOffer qid={qid} />
            </div>
        </div>
    );
};

export default BestOffer;
