import React, {useCallback} from 'react';

import {EAppActions} from 'constants/platforms/TPlatforms';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import * as i18nBlock from 'i18n/avia-order-disclaimers';

import Link from 'components/Link/Link';
import Mail from 'icons/16/Mail';
import Warning from 'icons/16/Warning';
import CommonAviaDisclaimer from 'projects/avia/components/AviaDisclaimers/CommonAviaDisclaimer';
import Disclaimer from './components/Disclaimer/Disclaimer';
import Card from 'components/Card/Card';

import {useCoordinator, usePlatform} from 'contexts/PlatformContext';

import cx from './AviaOrderDisclaimers.scss';

const QA = 'avia-order-disclaimers';

const AviaOrderDisclaimers: React.FC = () => {
    const helpLink = i18nBlock.disclaimerDashHelpDashLinkDashUrl();

    const deviceType = useDeviceType();
    const {isMobile} = deviceType;
    const {isTravelApp} = usePlatform();

    const coordinator = useCoordinator();
    const handleLinkClick: React.MouseEventHandler = useCallback(
        e => {
            const processed = coordinator.doAction(
                EAppActions.NAVIGATE_TO_EXTERNAL_URL,
                helpLink,
            );

            if (processed) {
                e.preventDefault();
            }
        },
        [coordinator, helpLink],
    );

    return (
        <Card
            className={cx('root', deviceMods('root', deviceType), {
                root_smallMarginBottom: isTravelApp,
            })}
            textColor="secondary"
            textSize="s"
            between="5"
            shadow="none"
            x={isMobile ? 4 : 0}
            y={isMobile ? 4 : 0}
        >
            <Disclaimer
                icon={<Warning />}
                {...prepareQaAttributes({
                    parent: QA,
                    current: 'baggage',
                })}
            >
                {i18nBlock.disclaimerDashBaggageDashText()}
            </Disclaimer>

            <Disclaimer
                icon={<Warning />}
                {...prepareQaAttributes({
                    parent: QA,
                    current: 'partners',
                })}
            >
                <CommonAviaDisclaimer />
            </Disclaimer>

            <Disclaimer
                icon={<Mail />}
                {...prepareQaAttributes({
                    parent: QA,
                    current: 'prices',
                })}
            >
                {insertJSXIntoKey(i18nBlock.disclaimerDashHelpDashText)({
                    link: (
                        <Link
                            key="disclaimer-link"
                            url={helpLink}
                            theme="normal"
                            target="_blank"
                            rel="noopener noreferrer"
                            onClick={handleLinkClick}
                        >
                            {i18nBlock.disclaimerDashHelpDashLinkDashText()}
                        </Link>
                    ),
                })}
            </Disclaimer>
        </Card>
    );
};

export default AviaOrderDisclaimers;
