import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import cx from './Disclaimer.scss';

interface IDisclaimerProps extends IWithClassName, IWithQaAttributes {
    icon?: React.ReactNode;
}

const Disclaimer: React.FC<IDisclaimerProps> = props => {
    const {className, icon, children} = props;

    return (
        <div className={cx('root', className)} {...prepareQaAttributes(props)}>
            <span className={cx('icon')}>{icon}</span>
            <div>{children}</div>
        </div>
    );
};

export default Disclaimer;
