import {FC} from 'react';

import {EFareFamilyTermCode} from 'server/api/AviaTicketDaemonApi/types/IAviaTDFareFamily';

import {INormalizedFareFamily} from 'reducers/avia/utils/ticketDaemon/normalizeFareFamilies';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import * as i18nBlock from 'i18n/avia-AviaOrder-FareFamilies';

import Heading from 'components/Heading/Heading';
import Box from 'components/Box/Box';
import {AviaCarryOnInfo} from 'projects/avia/components/AviaResultVariant/components/AviaCarryOnInfo/AviaCarryOnInfo';
import {AviaBaggageInfo} from 'projects/avia/components/AviaResultVariant/components/AviaBaggageInfo/AviaBaggageInfo';
import ExpandedRefundInfo from 'projects/avia/components/RefundInfo/ExpandedRefundInfo';
import ChangingCarriageInfo from 'projects/avia/components/ChangingCarriageInfo/ChangingCarriageInfo';
import MilesInfo from 'projects/avia/components/MilesInfo/MilesInfo';
import BottomSheet from 'components/BottomSheet/BottomSheet';

export interface ITariffDetailsBottomSheetProps {
    selectedVariant: IResultAviaVariant;
    fareFamily: INormalizedFareFamily;
    isVisible: boolean;
    toggleVisible: () => void;
}

const TariffDetailsBottomSheet: FC<ITariffDetailsBottomSheetProps> = ({
    selectedVariant,
    fareFamily,
    isVisible,
    toggleVisible,
}) => {
    const {tariffGroupName: tariffName, terms} = fareFamily;
    const places = terms[EFareFamilyTermCode.carryOn]?.places || 0;
    const weight = terms[EFareFamilyTermCode.carryOn]?.weight;
    const included = Boolean(places);
    const refund = terms[EFareFamilyTermCode.refundable] || null;
    const changingCarriage = terms[EFareFamilyTermCode.changingCarriage];
    const miles = terms[EFareFamilyTermCode.miles];

    return (
        <BottomSheet isOpened={isVisible} onClose={toggleVisible}>
            <Heading level={3}>
                {i18nBlock.tariffDashTitle({
                    tariffName,
                })}
            </Heading>
            <Box between={3} above={4}>
                <AviaCarryOnInfo
                    places={places}
                    weight={weight}
                    included={included}
                />
                <AviaBaggageInfo variant={selectedVariant} />
                <ExpandedRefundInfo refund={refund} />
                {changingCarriage && (
                    <ChangingCarriageInfo changingCarriage={changingCarriage} />
                )}
                <MilesInfo milesTerm={miles} />
            </Box>
        </BottomSheet>
    );
};

export default TariffDetailsBottomSheet;
