import {
    IFFRefundableTermRule,
    IFFChangingCarriageTermRule,
    IFFMilesTermRule,
    IFFSeatSelectionCheckInTermRule,
    EFareFamilyAvailability,
} from 'server/api/AviaTicketDaemonApi/types/IAviaTDFareFamily';

export class TermsHelper {
    static getAvailability(
        rule?:
            | IFFRefundableTermRule
            | IFFChangingCarriageTermRule
            | IFFSeatSelectionCheckInTermRule,
    ): EFareFamilyAvailability | null {
        return rule?.availability ?? null;
    }

    static getMiles(mileRule?: IFFMilesTermRule): number | null {
        if (mileRule) {
            const milesCount = parseInt(mileRule.miles, 10);

            if (isNaN(milesCount)) {
                return null;
            }

            return milesCount;
        }

        return null;
    }
}
