import {useMobile} from 'utilities/hooks/useMobile';

import cx from './styles.scss';

interface IAviaFlightPlaceholder {
    isRoundtrip: boolean;
}

export default function AviaFlightPlaceholder({
    isRoundtrip,
}: IAviaFlightPlaceholder) {
    return (
        <>
            <AviaFlightPlaceholderCard />
            {isRoundtrip && <AviaFlightPlaceholderCard />}
        </>
    );
}

function AviaFlightPlaceholderCard() {
    const isMobile = useMobile();

    return (
        <div className={cx('root')}>
            <div className={cx('title')}>
                <div className={cx('row', 'row_title', 'row_title_1')} />
                <div className={cx('row', 'row_title', 'row_title_2')} />
            </div>
            <div className={cx('flight', isMobile && 'flight_mobile')}>
                <div className={cx('company')} />
                <div className={cx('info', isMobile && 'info_mobile')}>
                    <div className={cx('main', isMobile && 'main_mobile')}>
                        <div className={cx('between-row')}>
                            <div
                                className={cx(
                                    'between-row_element',
                                    'between-row_left',
                                )}
                            />
                            <div
                                className={cx(
                                    'between-row_element',
                                    'between-row_right',
                                )}
                            />
                        </div>
                        <div
                            className={cx('row', 'row_plane', 'row_plane_1')}
                        />
                        <div
                            className={cx('row', 'row_plane', 'row_plane_2')}
                        />
                        <div
                            className={cx('row', 'row_plane', 'row_plane_3')}
                        />
                    </div>
                    <div
                        className={cx(
                            'separator',
                            isMobile && 'separator_mobile',
                        )}
                    />
                    <div
                        className={cx(
                            'additional',
                            isMobile && 'additional_mobile',
                        )}
                    >
                        <div className={cx('li-row')}>
                            <div
                                className={cx('li-row_element', 'li-row_point')}
                            />
                            <div
                                className={cx(
                                    'li-row_element',
                                    'li-row_text',
                                    'li-row_text_1',
                                )}
                            />
                        </div>
                        <div className={cx('li-row')}>
                            <div
                                className={cx('li-row_element', 'li-row_point')}
                            />
                            <div
                                className={cx(
                                    'li-row_element',
                                    'li-row_text',
                                    'li-row_text_2',
                                )}
                            />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    );
}
