import {DAY} from 'utilities/dateUtils/constants';

import {StorageSaverWithExpiration} from 'utilities/localStorage/StorageSaverWithExpiration';

class WasClosedSaver {
    private _wasClosed: boolean = false;

    private readonly storageSaver: StorageSaverWithExpiration<boolean>;

    get wasClosed(): boolean {
        return this._wasClosed;
    }

    constructor() {
        this.storageSaver = new StorageSaverWithExpiration<boolean>(
            'order-subscription-modal-was-closed',
            DAY,
        );

        this._wasClosed = Boolean(this.storageSaver.read());
    }

    saveWasClosed(): void {
        this._wasClosed = true;

        this.storageSaver.save(true);
    }
}

export default new WasClosedSaver();
