import React from 'react';

import {EAviaClassType} from 'types/avia/EAviaClassType';
import {IWithClassName} from 'types/withClassName';

import {formatCountOfPassengers} from 'utilities/formatCount';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/avia-AviaOrder-PriceList';

import Text from 'components/Text/Text';

import cx from './PriceListTitle.scss';

interface IAviaOrderPriceListTitleProps
    extends IWithQaAttributes,
        IWithClassName {
    totalSeats: number;
    klass: EAviaClassType;
}

const PriceListTitle: React.FC<IAviaOrderPriceListTitleProps> = props => {
    const {totalSeats, klass, className} = props;

    return (
        <div className={className} {...prepareQaAttributes(props)}>
            <Text
                size="l"
                tag="div"
                className={cx('countPassengers')}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'passengers',
                })}
            >
                {formatCountOfPassengers(totalSeats)}
            </Text>
            <Text
                color="secondary"
                size="m"
                {...prepareQaAttributes({parent: props, current: 'klass'})}
            >
                {klassToi18n(klass)}
            </Text>
        </div>
    );
};

function klassToi18n(klass: EAviaClassType): string {
    switch (klass) {
        case EAviaClassType.BUSINESS:
            return i18nBlock.businessDashClass();
        case EAviaClassType.ECONOMY:
            return i18nBlock.economyDashClass();
        default:
            return '';
    }
}

export default PriceListTitle;
