import {FC, useCallback} from 'react';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import {usePreparedVariants} from 'projects/avia/components/AviaResultVariant/components/TariffSelector/hooks/usePreparedVariants';
import Carousel from 'components/Carousel/Carousel';
import Price from 'components/Price/Price';
import Text from 'components/Text/Text';
import Card from 'components/Card/Card';
import Flex from 'components/Flex/Flex';
import ShortBaggageInfo from 'projects/avia/components/AviaResultVariant/components/ShortBaggageInfo/ShortBaggageInfo';

import cx from './TariffsPreview.scss';

export interface ITariffsPreview {
    variants: IResultAviaVariant[];
    selectedVariant?: IResultAviaVariant | null;
    onSelect?(variant: IResultAviaVariant): void;
}

const TariffsPreview: FC<ITariffsPreview> = ({
    variants,
    selectedVariant,
    onSelect,
}) => {
    const preparedTariffs = usePreparedVariants(variants);

    const handleOnItemClick = useCallback(
        (variant: IResultAviaVariant) => () => onSelect?.(variant),
        [onSelect],
    );

    return (
        <Carousel spaceBetween={2}>
            {preparedTariffs.map((tariff, index) => (
                <Card
                    x={4}
                    y={4}
                    shadow="none"
                    key={index}
                    className={cx('root', {
                        root_active: tariff.variant === selectedVariant,
                    })}
                    onClick={handleOnItemClick(tariff.variant)}
                >
                    <Flex justifyContent="space-between">
                        <Text size="l" weight="bold">
                            <Price {...tariff.variant.price.tariff} />
                        </Text>
                        <ShortBaggageInfo
                            hideCarryOnSize
                            variant={tariff.variant}
                        />
                    </Flex>
                </Card>
            ))}
        </Carousel>
    );
};

export default TariffsPreview;
