import {useMemo} from 'react';
import partition from 'lodash/partition';

import {IAviaOrderOffers} from 'selectors/avia/order/aviaOrderSelector';
import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import {getAviaOfferType} from 'projects/avia/lib/search/offerType';

export default function useOffers(
    rawOffers: IAviaOrderOffers | null,
    variants: IResultAviaVariant[] | null,
): IAviaOrderOffers | null {
    return useMemo(() => {
        if (!rawOffers || !variants) {
            return null;
        }

        const [avia, other] = partition(
            variants.slice(1),
            variant => variant.price.fromCompany,
        );

        return {
            variantsByTariff: rawOffers.variantsByTariff,
            cheapest: variants[0] ?? rawOffers.variantsByTariff.cheapest,
            avia,
            other,
            offerType: getAviaOfferType(variants),
        };
    }, [rawOffers, variants]);
}
