/* eslint-disable camelcase */
import {useEffect} from 'react';
import {useDispatch} from 'react-redux';
import {useLocation} from 'react-router-dom';

import requestOrderThunkAction from 'reducers/avia/order/thunk/requestOrderThunkAction';

import getQueryByLocation from 'utilities/getQueryByLocation/getQueryByLocation';

export default function useRequestOrder(isFetched: boolean): void {
    const dispatch = useDispatch();
    const location = useLocation();

    const {
        adult_seats,
        children_seats,
        klass,
        oneway,
        return_date,
        infant_seats,
        fromId,
        toId,
        when,
        forward,
        backward,
        partner,
        fromError,
    } = getQueryByLocation(location, false) as any;

    useEffect(() => {
        if (isFetched) {
            return;
        }

        dispatch(
            requestOrderThunkAction({
                params: {
                    adult_seats,
                    children_seats,
                    klass,
                    oneway,
                    return_date,
                    infant_seats,
                    fromId,
                    toId,
                    when,
                    forward,
                    backward,
                    partner,
                    fromError,
                },
            }),
        );
    }, [
        adult_seats,
        backward,
        children_seats,
        dispatch,
        forward,
        fromError,
        fromId,
        infant_seats,
        isFetched,
        klass,
        oneway,
        partner,
        return_date,
        toId,
        when,
    ]);
}
