/* eslint-disable camelcase */
import {FC, useCallback, useEffect} from 'react';
import {compose} from 'redux';
import {connect} from 'react-redux';
import {parse} from 'query-string';
import {RouteComponentProps} from 'react-router-dom';

import {EAppActions} from 'constants/platforms/TPlatforms';

import {IAviaRedirectPageParams} from 'server/api/AviaTicketDaemonApi/types/IAviaTDRedirect';
import {EAviaGoal} from 'utilities/metrika/types/goals/avia';

import {StoreInterface} from 'reducers/storeTypes';

import {aviaRedirectPageDataSelector} from 'selectors/avia/redirect/aviaRedirectPageDataSelector';
import {getAviaContext} from 'selectors/avia/aviaSelectors';

import {reachGoal} from 'utilities/metrika';
import {findVariant} from 'projects/avia/lib/redirect/prepareAnswer';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import {redirectDashTitle} from 'i18n/avia-promo';

import AviaRedirectProgress from 'projects/avia/pages/AviaRedirect/components/AviaRedirectProgress/AviaRedirectProgress';
import {LayoutEmpty} from 'components/Layouts/LayoutEmpty/LayoutEmpty';

import {serverFetchDataDispatcher} from 'contexts/ServerFetchDataContext';
import {useCoordinator} from 'contexts/PlatformContext';

import {aviaRedirectPageController} from 'server/redux/avia/aviaRedirectPageController';

import cx from './AviaRedirect.scss';

interface IAviaRedirectProps extends ReturnType<typeof mapStateToProps> {}

const AviaRedirect: FC<IAviaRedirectProps & RouteComponentProps> = ({
    redirectUrl,
    errorRedirectUrl,
    partner,
    location: routerLocation,
    context,
}) => {
    const coordinator = useCoordinator();

    const URLSearchParams = parse(routerLocation.search);
    const {toName, fromName, when, return_date} = context;
    const {boy} = URLSearchParams;

    const makeRedirectToPartner = useCallback(() => {
        reachGoal(EAviaGoal.REDIRECT_DEEPLINK);
        coordinator.doAction(EAppActions.REPORT_METRICS_EVENT, {
            name: EAviaGoal.REDIRECT_DEEPLINK,
        });

        if (redirectUrl) {
            location.href = redirectUrl;
        }
    }, [coordinator, redirectUrl]);

    const makeRedirectToErrorPage = useCallback(() => {
        if (errorRedirectUrl) {
            location.href = errorRedirectUrl;
        }
    }, [errorRedirectUrl]);

    const loadServerData = useCallback(() => {
        const params = parse(
            location.search,
        ) as unknown as IAviaRedirectPageParams;

        findVariant(params)
            .then(() => makeRedirectToPartner())
            .catch(() => makeRedirectToErrorPage());
    }, [makeRedirectToErrorPage, makeRedirectToPartner]);

    useEffect(() => {
        loadServerData();
        reachGoal(EAviaGoal.REDIRECT_SHOW_PAGE);
        coordinator.doAction(EAppActions.REPORT_METRICS_EVENT, {
            name: EAviaGoal.REDIRECT_SHOW_PAGE,
        });
    }, []);

    return (
        <LayoutEmpty>
            <div
                className={cx('redirect')}
                {...prepareQaAttributes('avia-order-redirect-page')}
            >
                <div className={cx('redirect__progress-wrapper')}>
                    <AviaRedirectProgress
                        partner={partner}
                        fromCity={fromName}
                        title={boy ? redirectDashTitle() : undefined}
                        toCity={toName}
                        dateForward={when}
                        dateBackward={return_date}
                        boy={Boolean(boy)}
                    />
                </div>
            </div>
        </LayoutEmpty>
    );
};

function mapStateToProps(state: StoreInterface) {
    const data = aviaRedirectPageDataSelector(state);
    const context = getAviaContext(state);

    return {
        ...data,
        context,
    };
}

export default compose(
    serverFetchDataDispatcher([aviaRedirectPageController]),
    connect(mapStateToProps),
)(AviaRedirect);
