import {createSelector} from 'reselect';

import {getAviaSearchVariantsViewSelector} from 'selectors/avia/search/getAviaSearchVariantsViewSelector';
import {aviaContextSelector} from 'selectors/avia/context/aviaContextSelector';
import {getGroupedVariantsInfo} from 'selectors/avia/search/getGroupedVariantsInfo';
import {filtersHashSelector} from 'selectors/avia/search/filters/filtersHashSelector';

import {isValidDate} from 'utilities/dateUtils';

export const aviaSearchResultPageSelector = createSelector(
    aviaContextSelector,
    getAviaSearchVariantsViewSelector,
    getGroupedVariantsInfo,
    filtersHashSelector,
    (context, searchVariantsView, variantsInfo, filtersHash) => {
        const fromTitle = (context.from && context.from.title) || '';
        const toTitle = (context.to && context.to.title) || '';
        const {klass} = context;
        const isRoundTrip = Boolean(
            context.return_date && isValidDate(context.return_date),
        );

        return {
            searchVariantsView,
            fromTitle,
            toTitle,
            variantsInfo,
            filtersHash,
            klass,
            isRoundTrip,
        };
    },
);
