import React from 'react';
import {useSelector} from 'react-redux';

import {TLD} from 'constants/tld';

import {
    getAviaFeaturesFlags,
    getAviaPointsData,
} from 'selectors/avia/aviaSelectors';

import getPlatform from 'utilities/deviceType/getPlatform';
import {useMobile} from 'utilities/hooks/useMobile';
import {useTld} from 'utilities/hooks/useTld';
import {getDirectionKeys} from 'projects/avia/pages/AviaSearchResult/components/AdBlock/utilities/getDirectionKeys';
import {directHelper} from 'projects/avia/lib/directHelper';

import {Direct} from 'components/Direct/Direct';

import cx from './AdBlock.scss';

const AdBlock: React.FC = () => {
    const tld = useTld();
    const platform = getPlatform(useMobile());
    const aviaPointsData = useSelector(getAviaPointsData);
    const aviaFeaturesFlags = useSelector(getAviaFeaturesFlags);
    const directionKeys = getDirectionKeys(aviaPointsData);

    if (
        !directionKeys ||
        tld !== TLD.RU ||
        !aviaFeaturesFlags.includes(directionKeys.adminKey)
    ) {
        return null;
    }

    return (
        <Direct
            className={cx('root')}
            blockId={directHelper.getId(tld, platform, directionKeys.helperKey)}
            blockIdStub={directHelper.getId(
                tld,
                platform,
                `${directionKeys.helperKey}Stub`,
            )}
        />
    );
};

export default AdBlock;
