import {RU_GEO_ID} from 'constants/common';

import {IAviaPointsData} from 'reducers/avia/data-types';

export function getDirectionKeys(aviaPointsData: IAviaPointsData): Nullable<{
    adminKey: string;
    helperKey: string;
}> {
    if (!aviaPointsData.from || !aviaPointsData.to) {
        return null;
    }

    let adminFrom;
    let adminTo;
    let helperFrom;
    let helperTo;

    if (aviaPointsData.from.country?.geoId === RU_GEO_ID) {
        adminFrom = 'RUSSIA';
        helperFrom = 'russia';
    } else {
        adminFrom = 'FOREIGN';
        helperFrom = 'foreign';
    }

    if (aviaPointsData.to.country?.geoId === RU_GEO_ID) {
        adminTo = 'RUSSIA';
        helperTo = 'Russia';
    } else {
        adminTo = 'FOREIGN';
        helperTo = 'Foreign';
    }

    return {
        adminKey: `${adminFrom}_TO_${adminTo}`,
        helperKey: `${helperFrom}To${helperTo}`,
    };
}
