import {useMemo} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import {
    resetDirectionAirportsFilter,
    resetFilterValue,
    resetTransferFilter,
} from 'reducers/avia/search/results/filters/actions';
import {TAviaFilterKey} from 'reducers/avia/search/results/filters/reducer';

import {aviaFiltersStateSelector} from 'selectors/avia/search/filters/activeFilters';

import * as i18nBlock from 'i18n/avia-search';

import NoResultsAfterFiltration from 'components/NoResultsAfterFiltration/NoResultsAfterFiltration';

const FILTERS_NAMES: Record<TAviaFilterKey, string> = {
    baggage: i18nBlock.filterDotWithDashBaggage(),
    transfer: i18nBlock.filterDotTransfersDashPlaceholder(),
    time: i18nBlock.filterDotTimeDotTitle(),
    price: '',
    company: i18nBlock.filterDotCompanyDotFilterButtonText({count: 0}),
    airports: i18nBlock.filterDotAirportsDotTitle(),
    partners: i18nBlock.filterDotPartnersDotFilterButtonText(),
    plusPoints: i18nBlock.filterPlusPoints(),
};

export const AviaNoResultsAfterFiltration = (): JSX.Element => {
    const dispatch = useDispatch();
    const filterState = useSelector(aviaFiltersStateSelector);
    const activeFilters = useMemo(
        () =>
            Object.entries(filterState)
                .filter(([_key, value]) => value)
                .map(([key]) => ({
                    text: FILTERS_NAMES[key as TAviaFilterKey],
                    handler: (): void => {
                        const filterKey = key as TAviaFilterKey;

                        switch (filterKey) {
                            case 'airports':
                                dispatch(resetDirectionAirportsFilter());

                                break;
                            case 'transfer':
                                dispatch(resetTransferFilter());

                                break;
                            default:
                                dispatch(resetFilterValue(filterKey));
                        }
                    },
                })),
        [filterState, dispatch],
    );

    return (
        <NoResultsAfterFiltration
            title={i18nBlock.filtersDashNoDashResultsDashTitle()}
            subtitle={i18nBlock.filtersDashNoDashResultsDashSubtitle()}
            filters={activeFilters}
        />
    );
};
