import React, {useCallback} from 'react';
import {connect, useDispatch} from 'react-redux';

import {resetFilterValues} from 'reducers/avia/search/results/filters/actions';

import {getGroupedVariantsInfo} from 'selectors/avia/search/getGroupedVariantsInfo';

import {useMobile} from 'utilities/hooks/useMobile';

import * as i18nBlock from 'i18n/avia-search';

import Card from 'components/Card/Card';
import LinkButton from 'components/LinkButton/LinkButton';

type AviaResetFiltersBlockProps = ReturnType<typeof getGroupedVariantsInfo>;

const SEGMENTS_LIMIT = 20;

const AviaResetFiltersBlock: React.FC<AviaResetFiltersBlockProps> = ({
    all,
    shown,
    hidden,
}) => {
    const dispatch = useDispatch();
    const isMobile = useMobile();

    const handleReset = useCallback(() => {
        dispatch(resetFilterValues());
    }, [dispatch]);

    if (!hidden || shown > SEGMENTS_LIMIT || all < SEGMENTS_LIMIT) {
        return null;
    }

    return (
        <Card
            x={isMobile ? 3 : 8}
            y="5"
            textSize="m"
            shadow="default"
            below={isMobile ? 3 : 5}
        >
            <LinkButton onClick={handleReset}>
                {i18nBlock.filtersDotCancelDashCount({
                    count: i18nBlock.variantsDashCount({
                        count: hidden,
                    }),
                })}
            </LinkButton>
        </Card>
    );
};

export default connect(getGroupedVariantsInfo)(AviaResetFiltersBlock);
