import {FC, useCallback} from 'react';

import {ECommonGoal} from 'utilities/metrika/types/goals/common';

import {useExperiments} from 'utilities/hooks/useExperiments';
import {useBoolean} from 'utilities/hooks/useBoolean';
import {reachGoal} from 'utilities/metrika';

import {
    EUseHeaderScrollSlideDirection,
    useHeaderScrollSlide,
} from 'hooks/useHeaderScrollSlide';

import ModalWithHistoryBack from 'containers/withSupportHistoryBack/ModalWithHistoryBack/ModalWithHistoryBack';

import Modal, {EModalAnimationType} from 'components/Modal/Modal';
import SearchForm from 'projects/avia/components/SearchForm/SearchForm';

import AviaSearchInformation from 'projects/avia/containers/AviaSearchInformation/AviaSearchInformation';

import cx from './AviaSearchHeaderFormMobile.scss';

const HIDE_THRESHOLD = 104;
const RISE_THRESHOLD = 52;

const AviaSearchHeaderFormMobile: FC = ({children}) => {
    const {aviaNewTouchFilters} = useExperiments();
    const {
        value: modalIsVisible,
        setTrue: showModal,
        setFalse: hideModal,
    } = useBoolean(false);
    const {isRaised, isVisible, isFixed, direction} = useHeaderScrollSlide({
        hideThreshold: HIDE_THRESHOLD,
        riseThreshold: RISE_THRESHOLD,
    });

    const onCollapsedSearchFormClick = useCallback(() => {
        showModal();

        reachGoal(ECommonGoal.HEADER_SEARCH_FORM_INFORMATION_CLICK);
    }, [showModal]);

    if (!aviaNewTouchFilters) {
        return <>{children}</>;
    }

    return (
        <>
            <div
                className={cx('wrapper', {
                    wrapper_raised: isRaised,
                    wrapper_visible:
                        isVisible &&
                        direction === EUseHeaderScrollSlideDirection.UP,
                    wrapper_fixed: isFixed,
                })}
            >
                <div className={cx('searchInformationWrapper')}>
                    <AviaSearchInformation
                        className={cx('searchInformation')}
                        onClick={onCollapsedSearchFormClick}
                    />
                </div>
                {children}
            </div>
            <ModalWithHistoryBack
                isMobile
                fullScreen
                disableAutoFocus
                isVisible={modalIsVisible}
                verticalAlign="top"
                autoclosable={false}
                animation={EModalAnimationType.NONE}
                onClose={hideModal}
            >
                <Modal.Content>
                    <SearchForm
                        className={cx('searchForm')}
                        useFilters
                        onSubmit={hideModal}
                    />
                </Modal.Content>
            </ModalWithHistoryBack>
        </>
    );
};

export default AviaSearchHeaderFormMobile;
