import React from 'react';
import {useSelector} from 'react-redux';

import {EAviaInitSearchError} from 'types/avia/search/EAviaInitSearchError';

import {getGroupedVariantsInfo} from 'selectors/avia/search/getGroupedVariantsInfo';
import {isAviaDirectionSelector} from 'selectors/avia/context/isAviaDirectionSelector';

import AviaSearchErrorState from './states/Error';
import AviaNoResultsState from './states/NoResults';
import AviaNoResultsAfterFiltrationState from './states/NoResultsAfterFiltration';

interface IAviaNoSearchResultsProps {
    error: Nullable<EAviaInitSearchError>;
}

const AviaSearchInvalidState: React.FC<IAviaNoSearchResultsProps> = ({
    error,
}) => {
    const {all, hidden} = useSelector(getGroupedVariantsInfo);
    const isAviaDirection = useSelector(isAviaDirectionSelector);

    if (error && isAviaDirection) {
        return <AviaSearchErrorState />;
    } else if (all === hidden && all !== 0) {
        return <AviaNoResultsAfterFiltrationState />;
    } else if (!isAviaDirection || all === 0) {
        return <AviaNoResultsState />;
    }

    return null;
};

export default AviaSearchInvalidState;
