import {useEffect} from 'react';
import {useSelector} from 'react-redux';
import {createSelector} from 'reselect';

import {EAviaGoal} from 'utilities/metrika/types/goals/avia';

import {getAviaPointsData} from 'selectors/avia/aviaSelectors';

import {reachGoal} from 'utilities/metrika';

import * as i18nBlock from 'i18n/avia-emptySerp';

import DynamicsCommonContainer from 'projects/avia/components/Dynamics/Chart/DynamicsCommonContainer/DynamicsCommonContainer';
import Box from 'components/Box/Box';
import Heading from 'components/Heading/Heading';
import Card from 'components/Card/Card';
import Container from 'components/Layouts/Container/Container';

const phraseToSelector = createSelector(
    getAviaPointsData,
    points => points.to?.settlement?.phraseTo ?? '',
);

export function YakWithDynamic() {
    const phraseTo = useSelector(phraseToSelector);

    useEffect(() => {
        reachGoal(EAviaGoal.SEARCH_NO_RESULTS_DYNAMIC);
    }, []);

    return (
        <Container>
            <Box y="8">
                <Box textColor="success" below="2">
                    <Heading level="1">
                        {i18nBlock.yakDashWithDashDynamicDashTitle({
                            phraseTo,
                        })}
                    </Heading>
                </Box>
                <Box textSize="m" textColor="primary" below="5">
                    {i18nBlock.yakDashWithDashDynamicDashSubtitle()}
                </Box>
                <Card shadow="default" y="5" below="2" style={{minWidth: 1090}}>
                    <DynamicsCommonContainer view="yak" />
                </Card>
            </Box>
        </Container>
    );
}
