import {useCallback, useEffect, useState} from 'react';
import {withRouter} from 'react-router-dom';
import {parse} from 'query-string';
import {createSelector} from 'reselect';
import {useSelector} from 'react-redux';

import {EAviaGoal} from 'utilities/metrika/types/goals/avia';

import {getAviaPointsData} from 'selectors/avia/aviaSelectors';

import {reachGoal} from 'utilities/metrika';

import * as i18nBlock from 'i18n/avia-emptySerp';

import MapNearAirports, {
    ENearAirportsMapState,
} from 'projects/avia/components/MapNearAirports/MapNearAirports';
import Box from 'components/Box/Box';
import Heading from 'components/Heading/Heading';
import Container from 'components/Layouts/Container/Container';
import EmptySerpWithContainer from 'components/EmptySerpWithContainer/EmptySerpWithContainer';

import cx from './YakWithMap.scss';

const phraseFromSelector = createSelector(
    getAviaPointsData,
    points => points.to?.settlement?.phraseFrom ?? '',
);

const MIN_MAP_HEIGHT = 300;

export const YakWithMap = withRouter(function YakWithMap(props) {
    const [mapState, setMapState] = useState(ENearAirportsMapState.FETCHING);
    const phraseFrom = useSelector(phraseFromSelector);
    const params = parse(props.location.search) as any;
    const [mapHeight, setMapHeight] = useState(MIN_MAP_HEIGHT);

    useEffect(() => {
        reachGoal(EAviaGoal.SEARCH_NO_RESULTS_MAP);
    }, []);

    const updateMapSize = useCallback((node: HTMLElement | null) => {
        if (node?.clientHeight) {
            setMapHeight(
                node.clientHeight < MIN_MAP_HEIGHT
                    ? MIN_MAP_HEIGHT
                    : node.clientHeight,
            );
        }
    }, []);

    if (
        mapState === ENearAirportsMapState.ERROR ||
        mapState === ENearAirportsMapState.NO_POINTS
    ) {
        return <EmptySerpWithContainer />;
    }

    const isLoading = mapState === ENearAirportsMapState.FETCHING;

    return (
        <div className={cx('root', isLoading && 'root_loading')}>
            <Container>
                <Box textColor="success" below="2">
                    <Heading level="1">
                        {i18nBlock.yakDashWithDashMapDashTitle({
                            phraseFrom,
                        })}
                    </Heading>
                </Box>
                <Box textSize="m" textColor="primary" below="8">
                    {i18nBlock.yakDashWithDashMapDashSubtitle()}
                </Box>
            </Container>
            <div
                className={cx('map')}
                ref={updateMapSize}
                style={{height: mapHeight}}
            >
                <MapNearAirports
                    view="yak"
                    formParams={params}
                    onStateChange={setMapState}
                />
            </div>
        </div>
    );
});
