import React from 'react';
import {withRouter, RouteComponentProps} from 'react-router-dom';

import {YakType} from '../YakType';
import {useYakType} from './useYakType';
import {YakWithDynamic} from './YakWithDynamic';
import {YakWithMap} from './YakWithMap';

const DesktopYak: React.FC<RouteComponentProps> = props => {
    const yakType = useYakType(props.location);

    switch (yakType) {
        case YakType.DYNAMIC:
            return <YakWithDynamic />;
        case YakType.EMPTY:
        case YakType.MAP:
            return <YakWithMap />;
        default:
            return null;
    }
};

export default withRouter(DesktopYak);
