import React, {useEffect} from 'react';

import {EAviaGoal} from 'utilities/metrika/types/goals/avia';

import {reachGoal} from 'utilities/metrika';

import * as i18nBlock from 'i18n/avia-search';

import LayoutError500 from 'components/Layouts/LayoutError500/LayoutError500';

export default function AviaSearchErrorState(): React.ReactElement {
    useEffect(() => {
        reachGoal(EAviaGoal.SEARCH_SHOW_SEARCH_ERROR);
    }, []);

    return (
        <LayoutError500
            title={i18nBlock.errorDotTitle()}
            subtitle={i18nBlock.errorDotSubtitle()}
            action={{
                type: 'button',
                title: i18nBlock.errorDotActionDashTitle(),
                handler: (): void => document.location.reload(),
            }}
        />
    );
}
