import React, {useEffect} from 'react';
import loadable from '@loadable/component';

import {EAviaGoal} from 'utilities/metrika/types/goals/avia';

import {useMobile} from 'utilities/hooks/useMobile';
import {reachGoal} from 'utilities/metrika';

const MobileYak = loadable(() => import('./MobileYak'));
const DesktopYak = loadable(() => import('./DesktopYak'));

function AviaNoResultsState(): React.ReactElement {
    const isMobile = useMobile();

    useEffect(() => {
        reachGoal(EAviaGoal.SEARCH_NO_RESULTS);
    }, []);

    return <>{isMobile ? <MobileYak /> : <DesktopYak />}</>;
}

export default AviaNoResultsState;
