import React, {useEffect} from 'react';
import {useSelector} from 'react-redux';

import {EAviaGoal} from 'utilities/metrika/types/goals/avia';
import {EAviaClassType} from 'types/avia/EAviaClassType';

import {aviaContextSelector} from 'selectors/avia/context/aviaContextSelector';

import {reachGoal} from 'utilities/metrika';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import {useBoolean} from 'utilities/hooks/useBoolean';

import * as keyset from 'i18n/avia-searchHeader';

import Box from 'components/Box/Box';
import Card from 'components/Card/Card';
import Separator from 'components/Separator/Separator';
import CardWithDeviceLayout from 'components/CardWithDeviceLayout/CardWithDeviceLayout';
import {AviaNoResultsAfterFiltration} from 'projects/avia/pages/AviaSearchResult/components/AviaNoResultsAfterFiltration/AviaNoResultsAfterFiltration';
import Container from 'components/Layouts/Container/Container';
import Flex from 'components/Flex/Flex';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import ModalMapNearAirports from 'projects/avia/components/ModalMapNearAirports/ModalMapNearAirports';
import LocationIcon from 'icons/16/Location';
import {SerpDynamics} from 'projects/avia/components/Dynamics/Chart/SerpDynamics/SerpDynamics';
import LinkButton from 'components/LinkButton/LinkButton';

import cx from '../AviaSearchInvalidState.scss';

const AviaNoResultsAfterFiltrationState: React.FC = () => {
    const deviceType = useDeviceType();

    const {
        value: isNearAirportsVisible,
        setTrue: showNearAirports,
        setFalse: hideNearAirports,
    } = useBoolean(false);

    const {klass} = useSelector(aviaContextSelector);

    const enableDynamics = klass === EAviaClassType.ECONOMY;

    useEffect(() => {
        reachGoal(EAviaGoal.SEARCH_NO_RESULTS_AFTER_FILTRATION);
    }, []);

    return (
        <>
            <Container
                className={cx(
                    'content',
                    deviceMods('content', deviceType),
                    'content_fullHeight',
                )}
            >
                {deviceType.isMobile && (
                    <CardWithDeviceLayout>
                        <AviaNoResultsAfterFiltration />
                    </CardWithDeviceLayout>
                )}
                {deviceType.isDesktop && (
                    <Card
                        className={cx('content_fullHeight')}
                        shadow="default"
                        below={5}
                    >
                        <Box x={8} y={5}>
                            <Flex flexDirection="column">
                                <Flex
                                    inline
                                    between="5"
                                    justifyContent="space-between"
                                    alignItems="center"
                                >
                                    {enableDynamics && <SerpDynamics />}

                                    <LinkButton
                                        onClick={showNearAirports}
                                        {...prepareQaAttributes(
                                            'avia-nearest-airports-link',
                                        )}
                                    >
                                        <TextWithIcon
                                            text={keyset.airportDashNearby()}
                                            iconLeft={LocationIcon}
                                        />
                                    </LinkButton>
                                </Flex>
                            </Flex>
                        </Box>
                        <Separator />
                        <AviaNoResultsAfterFiltration />
                    </Card>
                )}
            </Container>

            <ModalMapNearAirports
                isVisible={isNearAirportsVisible}
                onClose={hideNearAirports}
            />
        </>
    );
};

export default AviaNoResultsAfterFiltrationState;
