import React, {useCallback} from 'react';

import EHeaderBorderBottomType from 'components/Header/types/EHeaderBorderBottomType';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import scrollTo from 'utilities/dom/scrollTo';

import AviaLayout from 'projects/avia/components/AviaLayout';
import AviaSearchFilters from 'projects/avia/pages/AviaSearchResult/components/AviaSearchFilters/AviaSearchFilters';
import AviaSearchHeaderFormDesktop from 'projects/avia/pages/AviaSearchResult/components/AviaSearchHeaderForm/AviaSearchHeaderFormDesktop/AviaSearchHeaderFormDesktop';
import AviaSearchHeaderFormMobile from 'projects/avia/pages/AviaSearchResult/components/AviaSearchHeaderForm/AviaSearchHeaderFormMobile/AviaSearchHeaderFormMobile';

import cx from './AviaSearchLayout.scss';

export interface IAviaSearchLayoutProps {
    isSkeletons?: boolean;
    filtersAreVisible?: boolean;
    searchFormInitialIsExpanded?: boolean;
}

const AviaSearchLayout: React.FC<IAviaSearchLayoutProps> = ({
    children,
    isSkeletons,
    filtersAreVisible,
    searchFormInitialIsExpanded,
}) => {
    const {isMobile, isDesktop} = useDeviceType();

    const AviaSearchHeaderForm = isMobile
        ? AviaSearchHeaderFormMobile
        : AviaSearchHeaderFormDesktop;

    const handleOnChange = useCallback(() => {
        scrollTo({top: 0, behavior: 'smooth'});
    }, []);

    const filters = filtersAreVisible && (
        <AviaSearchFilters
            isSkeletons={isSkeletons}
            onChange={handleOnChange}
        />
    );

    return (
        <AviaLayout
            headerClassName={cx('header', {
                header_withBorder: isMobile && !filtersAreVisible,
            })}
            searchFormInitialIsExpanded={searchFormInitialIsExpanded}
            headerBorderBottomType={EHeaderBorderBottomType.NONE}
            hideSearchInformation={isDesktop}
        >
            <AviaSearchHeaderForm>{filters}</AviaSearchHeaderForm>
            {children}
        </AviaLayout>
    );
};

export default AviaSearchLayout;
