import React from 'react';

import {
    prepareCustomQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import {useAviaUiContext} from 'projects/avia/context/AviaUiContext';

import cx from './AviaSearchResultFog.scss';

const ROOT_QA = 'aviaSearchResultFog';

const AviaSearchResultFog: React.FC = () => {
    const {overlayIsVisible} = useAviaUiContext();

    return (
        <div
            className={cx('fog', overlayIsVisible && 'visible')}
            {...prepareQaAttributes(ROOT_QA)}
            {...prepareCustomQaAttributes(
                'data-active',
                String(overlayIsVisible),
            )}
        />
    );
};

export default AviaSearchResultFog;
