import React, {useEffect, useMemo} from 'react';

import {IAviaVariantGroup} from 'selectors/avia/utils/denormalization/variantGroup';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Box from 'components/Box/Box';
import Card from 'components/Card/Card';
import MinLoaderTime from 'components/MinLoaderTime/MinLoaderTime';
import AviaResultVariantSkeleton from 'projects/avia/components/AviaResultVariantSkeleton/AviaResultVariantSkeleton';

import {useShowLogger} from 'projects/avia/pages/AviaSearchResult/useShowLogger';

import AviaVariantsSlice from '../AviaVariantsSlice/AviaVariantsSlice';

import cx from './AviaSearchTopResult.scss';

interface IAviaSearchTopResultProps {
    variants: IAviaVariantGroup[];
    isSkeletons: boolean;
    isSortByInterest: boolean;
    isRoundTrip: boolean;
    minLoaderTime: number;
}

const AviaSearchTopResult: React.FC<IAviaSearchTopResultProps> = ({
    isSkeletons,
    isSortByInterest,
    isRoundTrip,
    variants,
    minLoaderTime,
}) => {
    const deviceType = useDeviceType();
    const showLogger = useShowLogger(0, isSortByInterest);

    useEffect(() => {
        showLogger(variants);
    }, [variants, showLogger]);

    const loaderNode = useMemo(
        () => (
            <Box between={3}>
                {[1, 2].map(index => (
                    <Card
                        className={cx('skeletonCard')}
                        shadow="default"
                        key={index}
                    >
                        <AviaResultVariantSkeleton isRoundTrip={isRoundTrip} />
                    </Card>
                ))}
            </Box>
        ),
        [isRoundTrip],
    );

    return (
        <Box
            className={cx(deviceMods('root', deviceType))}
            below={deviceType.isMobile ? 3 : 5}
        >
            <MinLoaderTime
                isLoaderNeeded={isSkeletons}
                minLoaderTime={minLoaderTime}
                loaderNode={loaderNode}
                componentNode={<AviaVariantsSlice variants={variants} />}
            />
        </Box>
    );
};

export default AviaSearchTopResult;
