import {FunctionComponent} from 'react';

import Flex from 'components/Flex/Flex';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import ButtonSkeleton from 'components/Skeletons/ButtonSkeleton/ButtonSkeleton';

import cx from './Skeleton.scss';

const Skeleton: FunctionComponent = () => (
    <div className={cx('root')}>
        <Flex below={4} flexDirection="column">
            <TextSkeleton className={cx('title')} />
            <TextSkeleton size="s" className={cx('info')} />
        </Flex>

        <Flex>
            <ButtonSkeleton className={cx('day')} />
            <ButtonSkeleton className={cx('day')} />
            <ButtonSkeleton className={cx('day')} />
        </Flex>

        <div>
            <TextSkeleton className={cx('buttonText')} />
            <TextSkeleton className={cx('buttonText')} />
            <TextSkeleton className={cx('buttonText')} />
        </div>
    </div>
);

export default Skeleton;
