import React from 'react';

import {IAviaVariantGroup} from 'selectors/avia/utils/denormalization/variantGroup';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Box from 'components/Box/Box';
import Card from 'components/Card/Card';
import AviaResultVariantContainer from 'projects/avia/components/AviaResultVariant/AviaResultVariantContainer';
import AviaSearchResultFog from 'projects/avia/pages/AviaSearchResult/components/AviaSearchResultFog/AviaSearchResultFog';

import cx from './AviaVariantsSlice.scss';

interface IAviaVariantsSliceProps {
    variants: IAviaVariantGroup[];
    renderIsDynamic?: boolean;
}

const AviaVariantsSlice: React.FC<IAviaVariantsSliceProps> = ({
    variants,
    renderIsDynamic,
}) => {
    const deviceType = useDeviceType();

    return (
        <Box between="3">
            {variants.map(variantGroup => (
                <Card
                    key={variantGroup.key}
                    className={cx(
                        'card',
                        deviceType.isDesktop && 'card_interactive',
                    )}
                    shadow="default"
                >
                    <AviaResultVariantContainer
                        group={variantGroup}
                        renderIsDynamic={renderIsDynamic}
                    />
                    <AviaSearchResultFog />
                </Card>
            ))}
        </Box>
    );
};

export default React.memo(AviaVariantsSlice);
