import React, {useMemo} from 'react';

import TValidDataForRequestDynamic from 'types/avia/dynamic/TValidDataForRequestDynamic';

import {TDynamicsDaysInfo} from 'reducers/avia/aviaPriceIndex/utils/convertPriceIndexDataToDynamicsData';

import {getDynamicsCalendarDayType} from 'projects/avia/components/Dynamics/utilities/getDynamicsCalendarDayType';
import getFiltersForUrl from 'projects/avia/utilities/getFiltersForUrl';
import {IDayWithPrice} from 'projects/avia/components/Dynamics/utilities/getPriceHintInfo';
import getDatesDelta from 'projects/avia/lib/dynamic/getDatesDelta';

import DynamicDayButton from 'projects/avia/pages/AviaSearchResult/components/DynamicDayButton/DynamicDayButton';
import cx from 'projects/avia/pages/AviaSearchResult/components/DesktopDynamics/DesktopDynamics.scss';
import Carousel from 'components/Carousel/Carousel';

export interface IDays {
    requestParams: TValidDataForRequestDynamic;
    priceDays: IDayWithPrice[];
    weekPrices: TDynamicsDaysInfo;
    onOpenDynamics: () => void;
}

const Days: React.FC<IDays> = ({
    requestParams,
    priceDays,
    weekPrices,
    onOpenDynamics,
}) => {
    const {searchForm, filters} = requestParams;
    const dayDelta = getDatesDelta(searchForm);

    const filtersForUrl = useMemo(() => getFiltersForUrl(filters), [filters]);

    const dynamicPriceDays = priceDays.map(day => ({
        ...day,
        ...weekPrices[day.date],
    }));
    const dayPrices = dynamicPriceDays.map(({price}) => ({price}));

    const daysInfo = dynamicPriceDays.map(({date, price, status}, index) => {
        const datePriceType = getDynamicsCalendarDayType(
            {price: price ?? null},
            dayPrices,
        );
        const prevDate = index > 0 ? priceDays[index - 1].date : undefined;

        return {
            date,
            price,
            status,
            datePriceType,
            prevDate,
        };
    });

    return (
        <Carousel
            className={cx('carousel')}
            spaceBetween={1}
            leftOffset={32}
            rightOffset={32}
            spaceBefore={8}
            spaceAfter={8}
        >
            {daysInfo.map(({date, datePriceType, price, status, prevDate}) => (
                <DynamicDayButton
                    key={date}
                    datePriceType={datePriceType}
                    date={date}
                    dayDelta={dayDelta}
                    searchForm={searchForm}
                    filtersForUrl={filtersForUrl}
                    onOpenDynamics={onOpenDynamics}
                    price={price}
                    status={status}
                    prevDate={prevDate}
                    size="l"
                />
            ))}
        </Carousel>
    );
};

export default React.memo(Days);
