import {FunctionComponent} from 'react';

import Flex from 'components/Flex/Flex';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import ButtonSkeleton from 'components/Skeletons/ButtonSkeleton/ButtonSkeleton';

import cx from './Skeleton.scss';

const Skeleton: FunctionComponent = () => (
    <div className={cx('root')}>
        <Flex below={4} flexDirection="column">
            <TextSkeleton size="l" className={cx('title')} />
            <TextSkeleton className={cx('info')} />
        </Flex>

        <Flex below={4}>
            <ButtonSkeleton className={cx('day')} />
            <ButtonSkeleton className={cx('day')} />
            <ButtonSkeleton className={cx('day')} />
            <ButtonSkeleton className={cx('day')} />
            <ButtonSkeleton className={cx('day')} />
            <ButtonSkeleton className={cx('day')} />
            <ButtonSkeleton className={cx('day')} />
        </Flex>

        <TextSkeleton className={cx('buttonText')} />
    </div>
);

export default Skeleton;
