import {useEffect, useState} from 'react';
import {useSelector} from 'react-redux';
import {isEmpty} from 'lodash';

import {EAviaInitSearchError} from 'types/avia/search/EAviaInitSearchError';
import {ESearchFormFieldName} from 'components/SearchForm/types';

import {getGroupedVariantsInfo} from 'selectors/avia/search/getGroupedVariantsInfo';
import {isAviaDirectionSelector} from 'selectors/avia/context/isAviaDirectionSelector';
import {aviaSearchFormValuesSelector} from 'selectors/avia/searchFormValuesSelectors';
import {searchSuggestsSelector} from 'selectors/avia/searchForm/searchSuggestsSelector';

import validateForm from 'projects/avia/components/SearchForm/utilities/validateForm';
import {useMobile} from 'utilities/hooks/useMobile';

import {IAviaSearchLayoutProps} from '../components/AviaSearchLayout/AviaSearchLayout';

/**
 * Вычисляет пропсы для AviaSearchLayout
 * в невалидных состояниях: нет результатов, ошибка, отфильтровались в ноль ...
 * @param error
 */
export function useInvalidAviaSearchLayoutProps(
    error: Nullable<EAviaInitSearchError>,
): IAviaSearchLayoutProps {
    const [searchFormHasErrors, setSearchFormHasErrors] = useState(false);
    const searchForm = useSelector(aviaSearchFormValuesSelector);
    const suggests = useSelector(searchSuggestsSelector);

    useEffect(() => {
        if (
            !isEmpty(
                validateForm(searchForm, {
                    [ESearchFormFieldName.FROM]:
                        suggests[ESearchFormFieldName.FROM].value,
                    [ESearchFormFieldName.TO]:
                        suggests[ESearchFormFieldName.TO].value,
                }),
            )
        ) {
            setSearchFormHasErrors(true);
        }
    }, [searchForm, setSearchFormHasErrors, suggests]);

    const {all, hidden} = useSelector(getGroupedVariantsInfo);
    const isAviaDirection = useSelector(isAviaDirectionSelector);

    const isMobile = useMobile();

    if (error && isAviaDirection) {
        return {searchFormInitialIsExpanded: searchFormHasErrors};
    } else if (!isAviaDirection || all === 0) {
        return {searchFormInitialIsExpanded: isMobile};
    } else if (all === hidden) {
        return {filtersAreVisible: true};
    }

    return {};
}
