import React, {useEffect} from 'react';
import {isEqual} from 'lodash';
import {RouteComponentProps} from 'react-router-dom';
import {useDispatch} from 'react-redux';

import {fetchPartnersInfo} from 'reducers/avia/search/results/actions';

import {useScrollRestoration} from 'utilities/hooks/useScrollRestoration';

import {DynamicsModal} from 'projects/avia/components/Dynamics/Chart/DynamicsModal/DynamicsModal';

import {AviaUiProvider} from 'projects/avia/context/AviaUiContext';
import AviaSearchResult from 'projects/avia/pages/AviaSearchResult/AviaSearchResult';
import {AviaFiltersBufferProvider} from 'projects/avia/context/AviaFiltersBufferContext';
import AviaFilterValueSync from 'projects/avia/pages/AviaSearchResult/AviaFilterValueSync';

import {RumUiSubpage} from 'contexts/RumUiContext';

export default React.memo(
    function AviaSearchResultPage({
        location,
        isBackground,
    }: {
        location: RouteComponentProps['location'];
        isBackground: boolean;
    }) {
        const dispatch = useDispatch();

        useEffect(() => {
            dispatch(fetchPartnersInfo());
        }, [dispatch]);

        useScrollRestoration('manual');

        return (
            <RumUiSubpage page="avia-serp">
                <AviaUiProvider>
                    <AviaFiltersBufferProvider>
                        <AviaSearchResult
                            location={location}
                            isBackground={isBackground}
                        />
                        <DynamicsModal />
                        <AviaFilterValueSync />
                    </AviaFiltersBufferProvider>
                </AviaUiProvider>
            </RumUiSubpage>
        );
    },
    (prevProps, nextProps) =>
        isEqual(prevProps.location, nextProps.location) &&
        prevProps.isBackground === nextProps.isBackground,
);
