import {useCallback, useEffect, useRef} from 'react';
import {useDispatch} from 'react-redux';

import {loggerActions} from 'reducers/avia/aviaLogging/actions';

import {IAviaVariantGroup} from 'selectors/avia/utils/denormalization/variantGroup';

export function useShowLogger(start: number, interesting: boolean) {
    const dispatch = useDispatch();
    const startRef = useRef(start);

    useEffect(() => {
        startRef.current = start;
    }, [startRef, start]);

    return useCallback(
        (slice: IAviaVariantGroup[], count: number = 0) => {
            if (!slice.length) {
                return;
            }

            requestAnimationFrame(() =>
                dispatch(
                    loggerActions.logSearchShow({
                        variants: slice,
                        start: startRef.current + count + 1, // отсчет начинается с 1
                        interesting,
                    }),
                ),
            );
        },
        [dispatch, startRef, interesting],
    );
}
